/*****************************************************************************
*  LPC15xx demo program for LPCXpresso board
*
*  1. Use SCT1 timer to generate a 100 msec clock output @ SCT1_OUT0
*  2. SCT1_OUT0 is linked to P0_24 (green LED toggles every 100 msec)
*  3. Input clock to SCT1 is the SCT PLL running at 72 MHz
*****************************************************************************/
#include "LPC15xx.h"

extern void SCT1_Init(void);

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_SWM;         // enable the SWM clock
    LPC_SWM->PINASSIGN8        |= 0x000000FF;      // ASSIGN8(7:0) = FF
    LPC_SWM->PINASSIGN8        &= 0xFFFFFF18;      // P0_24 is SCT1_OUT0, ASSIGN8(7:0)

    LPC_SYSCON->PDRUNCFG    &= ~PDEN_SCT_PLL;      // power-up SCT PLL
    LPC_SYSCON->SCTPLLCLKSEL = 0;                  // select SCT PLL input = IRC
    LPC_SYSCON->SCTPLLCTRL   = (12 << 0) |         // MSEL = 12 -> M = MSEL + 1 = 13
                               (0  << 6);          // PSEL = 0 -> P = 1
    while (!(LPC_SYSCON->SCTPLLSTAT & 0x01));      // wait until SCT PLL locked

    SCT1_Init();                                   // Initialize SCT

    while (1)
    {
    }
}
